<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Rest\Wireless\V1;
use Twilio\Rest\Wireless\V1\CommandContext;
use Twilio\Rest\Wireless\V1\CommandList;
use Twilio\Rest\Wireless\V1\RatePlanContext;
use Twilio\Rest\Wireless\V1\RatePlanList;
use Twilio\Rest\Wireless\V1\SimContext;
use Twilio\Rest\Wireless\V1\SimList;
use Twilio\Version;

/**
 * @property V1 v1
 * @property CommandList commands
 * @property RatePlanList ratePlans
 * @property SimList sims
 * @method CommandContext commands(string $sid)
 * @method RatePlanContext ratePlans(string $sid)
 * @method SimContext sims(string $sid)
 */
class Wireless extends Domain {
    protected $_v1 = null;

    /**
     * Construct the Wireless Domain
     * 
     * @param Client $client Twilio\Rest\Client to communicate with
     *                                    Twilio
     * @return Wireless Domain for Wireless
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://wireless.twilio.com';
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     *
     * @return Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get($name) {
        $method = 'get' . ucfirst($name);
        if (method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     *
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call($name, $arguments) {
        $method = 'context' . ucfirst($name);
        if (method_exists($this, $method)) {
            return call_user_func_array(array($this, $method), $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.Wireless]';
    }

    /**
     * @return V1 Version v1 of wireless
     */
    protected function getV1() {
        if (!$this->_v1) {
            $this->_v1 = new V1($this);
        }
        return $this->_v1;
    }

    /**
     * @return CommandList
     */
    protected function getCommands() {
        return $this->v1->commands;
    }

    /**
     * @param string $sid A 34 character string that uniquely identifies this
     *                    resource.
     * @return CommandContext
     */
    protected function contextCommands($sid) {
        return $this->v1->commands($sid);
    }

    /**
     * @return RatePlanList
     */
    protected function getRatePlans() {
        return $this->v1->ratePlans;
    }

    /**
     * @param string $sid The sid
     * @return RatePlanContext
     */
    protected function contextRatePlans($sid) {
        return $this->v1->ratePlans($sid);
    }

    /**
     * @return SimList
     */
    protected function getSims() {
        return $this->v1->sims;
    }

    /**
     * @param string $sid A 34 character string that uniquely identifies this
     *                    resource.
     * @return SimContext
     */
    protected function contextSims($sid) {
        return $this->v1->sims($sid);
    }
}